/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.misc.TriPredicate;
import at.petrak.hexcasting.common.blocks.akashic.AkashicFloodfiller;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals.AkashicBookshelfPeripheral;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class AkashicRecordPeripheral
implements IPeripheral {
    private class_2338 recordPos;
    private class_1937 recordWorld;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    AkashicRecordPeripheral(class_2338 _pos, class_1937 world) {
        this.recordPos = _pos;
        this.recordWorld = world;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        return "akashic_record";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult readRecord() {
        FloodfillLogger sneakyPredicate = new FloodfillLogger();
        AkashicFloodfiller.floodFillFor((class_2338)this.recordPos, (class_1937)this.recordWorld, (float)0.0f, (TriPredicate)sneakyPredicate, (int)128);
        return MethodResult.of(sneakyPredicate.getRecordTable());
    }

    private class FloodfillLogger
    implements TriPredicate<class_2338, class_2680, class_1937> {
        private Map<String, Object> recordTable = new HashMap<String, Object>();

        private FloodfillLogger() {
        }

        public boolean test(class_2338 pos, class_2680 state, class_1937 world) {
            class_2586 be = world.method_8321(pos);
            if (be == null) {
                return false;
            }
            if (be instanceof BlockEntityAkashicBookshelf) {
                BlockEntityAkashicBookshelf shelf = (BlockEntityAkashicBookshelf)be;
                HexPattern pattern = shelf.getPattern();
                if (pattern == null) {
                    return false;
                }
                String angleSig = pattern.anglesSignature();
                if (!this.recordTable.containsKey(angleSig)) {
                    this.recordTable.put(angleSig, AkashicBookshelfPeripheral.shelfData(shelf));
                }
            }
            return false;
        }

        public Map<String, Object> getRecordTable() {
            return this.recordTable;
        }
    }
}

